/*

Boost Software License - Version 1.0 - August 17th, 2003

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

*/
module derelict.sdl2.functions;

private
{
    import core.stdc.stdio;
    import core.stdc.stdarg;
    import derelict.sdl2.types;
}

extern(C)
{
    // SDL.h
    alias nothrow int function(Uint32) da_SDL_Init;
    alias nothrow int function(Uint32) da_SDL_InitSubSystem;
    alias nothrow void function(Uint32) da_SDL_QuitSubSystem;
    alias nothrow Uint32 function(Uint32) da_SDL_WasInit;
    alias nothrow void function() da_SDL_Quit;

    // SDL_audio.h
    alias nothrow int function() da_SDL_GetNumAudioDrivers;
    alias nothrow const(char)* function(int) da_SDL_GetAudioDriver;
    alias nothrow int function(const(char)*) da_SDL_AudioInit;
    alias nothrow void function() da_SDL_AudioQuit;
    alias nothrow const(char)* function() da_SDL_GetCurrentAudioDriver;
    alias nothrow int function(SDL_AudioSpec*, SDL_AudioSpec*) da_SDL_OpenAudio;
    alias nothrow int function(int) da_SDL_GetNumAudioDevices;
    alias nothrow const(char)* function(int, int) da_SDL_GetAudioDeviceName;
    alias nothrow SDL_AudioDeviceID function(const(char)*, int, const(SDL_AudioSpec)*,SDL_AudioSpec*,int) da_SDL_OpenAudioDevice;
    alias nothrow SDL_AudioStatus function() da_SDL_GetAudioStatus;
    alias nothrow SDL_AudioStatus function(SDL_AudioDeviceID) da_SDL_GetAudioDeviceStatus;
    alias nothrow void function(int) da_SDL_PauseAudio;
    alias nothrow void function(SDL_AudioDeviceID, int) da_SDL_PauseAudioDevice;
    alias nothrow SDL_AudioSpec* function(SDL_RWops*, int, SDL_AudioSpec*, Uint8**, Uint32*) da_SDL_LoadWAV_RW;
    alias nothrow void function(Uint8*) da_SDL_FreeWAV;
    alias nothrow int function(SDL_AudioCVT*, SDL_AudioFormat, Uint8, int, SDL_AudioFormat, Uint8, int) da_SDL_BuildAudioCVT;
    alias nothrow int function(SDL_AudioCVT*) da_SDL_ConvertAudio;
    alias nothrow void function(Uint8*, const(Uint8)*, Uint32, int) da_SDL_MixAudio;
    alias nothrow void function(Uint8*, const(Uint8)*, SDL_AudioFormat, Uint32, int) da_SDL_MixAudioFormat;
    alias nothrow void function() da_SDL_LockAudio;
    alias nothrow void function(SDL_AudioDeviceID) da_SDL_LockAudioDevice;
    alias nothrow void function() da_SDL_UnlockAudio;
    alias nothrow void function(SDL_AudioDeviceID) da_SDL_UnlockAudioDevice;
    alias nothrow void function() da_SDL_CloseAudio;
    alias nothrow void function() da_SDL_CloseAudioDevice;
    alias nothrow int function(SDL_AudioDeviceID) da_SDL_AudioDeviceConnected;

    // SDL_clipboard.h
    alias nothrow int function(const(char)*) da_SDL_SetClipboardText;
    alias nothrow char* function() da_SDL_GetClipboardText;
    alias nothrow SDL_bool function() da_SDL_HasClipboardText;

    // SDL_cpuinfo.h
    alias nothrow int function() da_SDL_GetCPUCount;
    alias nothrow int function() da_SDL_GetCPUCacheLineSize;
    alias nothrow SDL_bool function() da_SDL_HasRDTSC;
    alias nothrow SDL_bool function() da_SDL_HasAltiVec;
    alias nothrow SDL_bool function() da_SDL_HasMMX;
    alias nothrow SDL_bool function() da_SDL_Has3DNow;
    alias nothrow SDL_bool function() da_SDL_HasSSE;
    alias nothrow SDL_bool function() da_SDL_HasSSE2;
    alias nothrow SDL_bool function() da_SDL_HasSSE3;
    alias nothrow SDL_bool function() da_SDL_HasSSE41;
    alias nothrow SDL_bool function() da_SDL_HasSSE42;

    // SDL_error.h
    alias nothrow void function(const(char)*, ...) da_SDL_SetError;
    alias nothrow const(char)* function() da_SDL_GetError;
    alias nothrow void function() da_SDL_ClearError;

    // SDL_events.h
    alias nothrow void function() da_SDL_PumpEvents;
    alias nothrow int function(SDL_Event*, int, SDL_eventaction, Uint32, Uint32) da_SDL_PeepEvents;
    alias nothrow SDL_bool function(Uint32) da_SDL_HasEvent;
    alias nothrow SDL_bool function(Uint32, Uint32) da_SDL_HasEvents;
    alias nothrow void function(Uint32) da_SDL_FlushEvent;
    alias nothrow void function(Uint32, Uint32) da_SDL_FlushEvents;
    alias nothrow int function(SDL_Event*) da_SDL_PollEvent;
    alias nothrow int function(SDL_Event*) da_SDL_WaitEvent;
    alias nothrow int function(SDL_Event*, int) da_SDL_WaitEventTimeout;
    alias nothrow int function(SDL_Event*) da_SDL_PushEvent;
    alias nothrow void function(SDL_EventFilter, void*) da_SDL_SetEventFilter;
    alias nothrow void function(SDL_EventFilter*, void**) da_SDL_GetEventFilter;
    alias nothrow void function(SDL_EventFilter, void*) da_SDL_AddEventWatch;
    alias nothrow void function(SDL_EventFilter, void*) da_SDL_DelEventWatch;
    alias nothrow void function(SDL_EventFilter, void*) da_SDL_FilterEvents;
    alias nothrow Uint8 function(Uint32, int) da_SDL_EventState;
    alias nothrow Uint32 function(int) da_SDL_RegisterEvents;

    // SDL_gamecontroller.h
    alias nothrow int function(const(char)*) da_SDL_GameControllerAddMapping;
    alias nothrow char* function(SDL_JoystickGUID) da_SDL_GameControllerMappingForGUID;
    alias nothrow char* function(SDL_GameController*) da_SDL_GameControllerMapping;
    alias nothrow SDL_bool function(int) da_SDL_IsGameController;
    alias nothrow const(char)* function(int) da_SDL_GameControllerNameForIndex;
    alias nothrow SDL_GameController* function(int) da_SDL_GameControllerOpen;
    alias nothrow const(char)* function(SDL_GameController*) da_SDL_GameControllerName;
    alias nothrow SDL_bool function(SDL_GameController*) da_SDL_GameControllerGetAttached;
    alias nothrow SDL_Joystick* function(SDL_GameController*) da_SDL_GameControllerGetJoystick;
    alias nothrow int function(int) da_SDL_GameControllerEventState;
    alias nothrow void function() da_SDL_GameControllerUpdate;
    alias nothrow SDL_GameControllerAxis function(const(char)*) da_SDL_GameControllerGetAxisFromString;
    alias nothrow const(char)* function(SDL_GameControllerAxis) da_SDL_GameControllerGetStringForAxis;
    alias nothrow SDL_GameControllerButtonBind function(SDL_GameController*, SDL_GameControllerAxis) da_SDL_GameControllerGetBindForAxis;
    alias nothrow Sint16 function(SDL_GameController*, SDL_GameControllerAxis) da_SDL_GameControllerGetAxis;
    alias nothrow SDL_GameControllerButton function(const(char*)) da_SDL_GameControllerGetButtonFromString;
    alias nothrow const(char)* function(SDL_GameControllerButton) da_SDL_GameControllerGetStringForButton;
    alias nothrow SDL_GameControllerButtonBind function(SDL_GameController*, SDL_GameControllerButton) da_SDL_GameControllerGetBindForButton;
    alias nothrow Uint8 function(SDL_GameController*, SDL_GameControllerButton) da_SDL_GameControllerGetButton;
    alias nothrow void function(SDL_GameController*) da_SDL_GameControllerClose;


    // SDL_gesture.h
    alias nothrow int function(SDL_TouchID) da_SDL_RecordGesture;
    alias nothrow int function(SDL_RWops*) da_SDL_SaveAllDollarTemplates;
    alias nothrow int function(SDL_GestureID, SDL_RWops*) da_SDL_SaveDollarTemplate;
    alias nothrow int function(SDL_TouchID, SDL_RWops*) da_SDL_LoadDollarTemplates;

    // SDL_haptic.h
    alias nothrow int function() da_SDL_NumHaptics;
    alias nothrow const(char)* function(int) da_SDL_HapticName;
    alias nothrow SDL_Haptic* function(int) da_SDL_HapticOpen;
    alias nothrow int function(int) da_SDL_HapticOpened;
    alias nothrow int function(SDL_Haptic*) da_SDL_HapticIndex;
    alias nothrow int function() da_SDL_MouseIsHaptic;
    alias nothrow SDL_Haptic* function() da_SDL_HapticOpenFromMouse;
    alias nothrow int function(SDL_Joystick*) da_SDL_JoystickIsHaptic;
    alias nothrow SDL_Haptic* function(SDL_Joystick*) da_SDL_HapticOpenFromJoystick;
    alias nothrow int function(SDL_Haptic*) da_SDL_HapticClose;
    alias nothrow int function(SDL_Haptic*) da_SDL_HapticNumEffects;
    alias nothrow int function(SDL_Haptic*) da_SDL_HapticNumEffectsPlaying;
    alias nothrow uint function(SDL_Haptic*) da_SDL_HapticQuery;
    alias nothrow int function(SDL_Haptic*) da_SDL_HapticNumAxes;
    alias nothrow int function(SDL_Haptic*, SDL_HapticEffect*) da_SDL_HapticEffectSupported;
    alias nothrow int function(SDL_Haptic*, SDL_HapticEffect*) da_SDL_HapticNewEffect;
    alias nothrow int function(SDL_Haptic*, int, SDL_HapticEffect*) da_SDL_HapticUpdateEffect;
    alias nothrow int function(SDL_Haptic*, int, SDL_HapticEffect*) da_SDL_HapticRunEffect;
    alias nothrow int function(SDL_Haptic*, int) da_SDL_HapticStopEffect;
    alias nothrow int function(SDL_Haptic*, int) da_SDL_HapticDestroyEffect;
    alias nothrow int function(SDL_Haptic*, int) da_SDL_HapticGetEffectStatus;
    alias nothrow int function(SDL_Haptic*, int) da_SDL_HapticSetGain;
    alias nothrow int function(SDL_Haptic*, int) da_SDL_HapticSetAutocenter;
    alias nothrow int function(SDL_Haptic*) da_SDL_HapticPause;
    alias nothrow int function(SDL_Haptic*) da_SDL_HapticUnpause;
    alias nothrow int function(SDL_Haptic*) da_SDL_HapticStopAll;
    alias nothrow int function(SDL_Haptic*) da_SDL_HapticRumbleSupported;
    alias nothrow int function(SDL_Haptic*) da_SDL_HapticRumbleInit;
    alias nothrow int function(SDL_Haptic*, float, Uint32) da_SDL_HapticRumblePlay;
    alias nothrow int function(SDL_Haptic*) da_SDL_HapticRumbleStop;

    // SDL_hints.h
    alias nothrow SDL_bool function(const(char)*, const(char)*, SDL_HintPriority) da_SDL_SetHintWithPriority;
    alias nothrow SDL_bool function(const(char)*, const(char)*) da_SDL_SetHint;
    alias nothrow const(char)* function(const(char)*) da_SDL_GetHint;
    alias nothrow void function() da_SDL_ClearHints;

    // SDL_input.h
    alias nothrow int function() da_SDL_RedetectInputDevices;
    alias nothrow int function() da_SDL_GetNumInputDevices;
    alias nothrow const(char)* function(int) da_SDL_GetInputDeviceName;
    alias nothrow int function(int) da_SDL_IsDeviceDisconnected;

    // SDL_joystick.h
    alias nothrow int function() da_SDL_NumJoysticks;
    alias nothrow const(char)* function(int) da_SDL_JoystickNameForIndex;
    alias nothrow SDL_Joystick* function(int) da_SDL_JoystickOpen;
    alias nothrow const(char)* function(SDL_Joystick*) da_SDL_JoystickName;
    alias nothrow JoystickGUID function(int) da_SDL_JoystickGetDeviceGUID;
    alias nothrow JoystickGUID function(SDL_Joystick*) da_SDL_JoystickGetGUID;
    alias nothrow char* function(JoystickGUID) da_SDL_JoystickGetGUIDString;
    alias nothrow JoystickGUID function(const(char)*) da_SDL_JoystickGetGUIDFromString;
    alias nothrow SDL_bool function(SDL_Joystick*) da_SDL_JoystickGetAttached;
    alias nothrow SDL_JoystickID function(SDL_Joystick*) da_SDL_JoystickInstanceID;
    alias nothrow int function(SDL_Joystick*) da_SDL_JoystickNumAxes;
    alias nothrow int function(SDL_Joystick*) da_SDL_JoystickNumBalls;
    alias nothrow int function(SDL_Joystick*) da_SDL_JoystickNumHats;
    alias nothrow int function(SDL_Joystick*) da_SDL_JoystickNumButtons;
    alias nothrow int function(SDL_Joystick*) da_SDL_JoystickUpdate;
    alias nothrow int function(int) da_SDL_JoystickEventState;
    alias nothrow Sint16 function(SDL_Joystick*, int) da_SDL_JoystickGetAxis;
    alias nothrow Uint8 function(SDL_Joystick*, int) da_SDL_JoystickGetHat;
    alias nothrow int function(SDL_Joystick*, int, int*, int*) da_SDL_JoystickGetBall;
    alias nothrow Uint8 function(SDL_Joystick*, int) da_SDL_JoystickGetButton;
    alias nothrow void function(SDL_Joystick*) da_SDL_JoystickClose;

    // SDL_keyboard.h
    alias nothrow SDL_Window* function() da_SDL_GetKeyboardFocus;
    alias nothrow Uint8* function(int*) da_SDL_GetKeyboardState;
    alias nothrow SDL_Keymod function() da_SDL_GetModState;
    alias nothrow void function(SDL_Keymod) da_SDL_SetModState;
    alias nothrow SDL_Keycode function(SDL_Scancode) da_SDL_GetKeyFromScancode;
    alias nothrow SDL_Scancode function(SDL_Keycode) da_SDL_GetScancodeFromKey;
    alias nothrow const(char)* function(SDL_Scancode) da_SDL_GetScancodeName;
    alias nothrow SDL_Scancode function(const(char)*) da_SDL_GetScancodeFromName;
    alias nothrow const(char)* function(SDL_Keycode) da_SDL_GetKeyName;
    alias nothrow SDL_Keycode function(const(char)*) da_SDL_GetKeyFromName;
    alias nothrow void function() da_SDL_StartTextInput;
    alias nothrow SDL_bool function() da_SDL_IsTextInputActive;
    alias nothrow void function() da_SDL_StopTextInput;
    alias nothrow void function(SDL_Rect*) da_SDL_SetTextInputRect;
    alias nothrow SDL_bool function() da_SDL_HasScreenKeyboardSupport;
    alias nothrow SDL_bool function(SDL_Window*) da_SDL_IsScreenKeyboardShown;

    // SDL_loadso.h
    alias nothrow void* function(const(char)*) da_SDL_LoadObject;
    alias nothrow void* function(void*, const(char*)) da_SDL_LoadFunction;
    alias nothrow void function(void*) da_SDL_UnloadObject;

    // SDL_log.h
    alias nothrow void function(SDL_LogPriority) da_SDL_LogSetAllPriority;
    alias nothrow void function(int, SDL_LogPriority) da_SDL_LogSetPriority;
    alias nothrow SDL_LogPriority function(int) da_SDL_LogGetPriority;
    alias nothrow void function() da_SDL_LogResetPriorities;
    alias nothrow void function(const(char)*, ...) da_SDL_Log;
    alias nothrow void function(int, const(char)*, ...) da_SDL_LogVerbose;
    alias nothrow void function(int, const(char)*, ...) da_SDL_LogDebug;
    alias nothrow void function(int, const(char)*, ...) da_SDL_LogInfo;
    alias nothrow void function(int, const(char)*, ...) da_SDL_LogWarn;
    alias nothrow void function(int, const(char)*, ...) da_SDL_LogError;
    alias nothrow void function(int, const(char)*, ...) da_SDL_LogCritical;
    alias nothrow void function(int, SDL_LogPriority, const(char)*, ...) da_SDL_LogMessage;
    alias nothrow void function(int, SDL_LogPriority, const(char)*, va_list) da_SDL_LogMessageV;
    alias nothrow void function(SDL_LogOutputFunction, void**) da_SDL_LogGetOutputFunction;
    alias nothrow void function(SDL_LogOutputFunction, void*) da_SDL_LogSetOutputFunction;

    // SDL_messagebox.h
    alias nothrow int function(const(SDL_MessageBoxData)*, int) da_SDL_ShowMessageBox;
    alias nothrow int function(Uint32, const(char)*, const(char)*, SDL_Window*) da_SDL_ShowSimpleMessageBox;

    // SDL_mouse.h
    alias nothrow SDL_Window* function() da_SDL_GetMouseFocus;
    alias nothrow Uint32 function(int*, int*) da_SDL_GetMouseState;
    alias nothrow Uint32 function(int*, int*) da_SDL_GetRelativeMouseState;
    alias nothrow void function(SDL_Window*, int, int) da_SDL_WarpMouseInWindow;
    alias nothrow int function(SDL_bool) da_SDL_SetRelativeMouseMode;
    alias nothrow SDL_bool function() da_SDL_GetRelativeMouseMode;
    alias nothrow SDL_Cursor* function(const(Uint8)*, const(Uint8)*, int, int, int, int) da_SDL_CreateCursor;
    alias nothrow SDL_Cursor* function(SDL_Surface*, int, int) da_SDL_CreateColorCursor;
    alias nothrow SDL_Cursor* function(SDL_SystemCursor) da_SDL_CreateSystemCursor;
    alias nothrow void function(SDL_Cursor*) da_SDL_SetCursor;
    alias nothrow SDL_Cursor* function() da_SDL_GetCursor;
    alias nothrow void function(SDL_Cursor*) da_SDL_FreeCursor;
    alias nothrow int function(int) da_SDL_ShowCursor;

    // SDL_pixels.h
    alias nothrow const(char)* function(Uint32) da_SDL_GetPixelFormatName;
    alias nothrow SDL_bool function(Uint32, int*, Uint32*, Uint32*, Uint32*, Uint32*) da_SDL_PixelFormatEnumToMasks;
    alias nothrow Uint32 function(int, Uint32, Uint32, Uint32, Uint32) da_SDL_MasksToPixelFormatEnum;
    alias nothrow SDL_PixelFormat* function(Uint32) da_SDL_AllocFormat;
    alias nothrow void function(SDL_PixelFormat*) da_SDL_FreeFormat;
    alias nothrow SDL_Palette* function(int) da_SDL_AllocPalette;
    alias nothrow int function(SDL_PixelFormat*, SDL_Palette*) da_SDL_SetPixelFormatPalette;
    alias nothrow int function(SDL_Palette*, const(SDL_Color)*, int, int) da_SDL_SetPaletteColors;
    alias nothrow void function(SDL_Palette*) da_SDL_FreePalette;
    alias nothrow Uint32 function(const(SDL_PixelFormat)*, Uint8, Uint8, Uint8) da_SDL_MapRGB;
    alias nothrow Uint32 function(const(SDL_PixelFormat)*, Uint8, Uint8, Uint8, Uint8) da_SDL_MapRGBA;
    alias nothrow void function(Uint32, const(SDL_PixelFormat)*, Uint8*, Uint8*, Uint8*) da_SDL_GetRGB;
    alias nothrow void function(Uint32, const(SDL_PixelFormat)*, Uint8*, Uint8*, Uint8*, Uint8*) da_SDL_GetRGBA;
    alias nothrow void function(float, Uint16*) da_SDL_CalculateGammaRamp;

    // SDL_platform.h
    alias nothrow const(char)* function() da_SDL_GetPlatform;

    // SDL_power.h
    alias nothrow SDL_PowerState function(int*, int*) da_SDL_GetPowerInfo;

    // SDL_Rect.h
    alias nothrow SDL_bool function(const(SDL_Rect)*, const(SDL_Rect)*) da_SDL_HasIntersection;
    alias nothrow SDL_bool function(const(SDL_Rect)*, const(SDL_Rect)*, SDL_Rect*) da_SDL_IntersectRect;
    alias nothrow void function(const(SDL_Rect)*, const(SDL_Rect)*, SDL_Rect*) da_SDL_UnionRect;
    alias nothrow void function(const(SDL_Point)*, int, const(SDL_Rect)*, SDL_Rect*) da_SDL_EnclosePoints;
    alias nothrow SDL_bool function(const(SDL_Rect)*, int*, int*, int*, int*) da_SDL_IntersectRectAndLine;

    // SDL_Render.h
    alias nothrow int function() da_SDL_GetNumRenderDrivers;
    alias nothrow int function(int, SDL_RendererInfo*) da_SDL_GetRenderDriverInfo;
    alias nothrow int function(int, int, Uint32, SDL_Window**, SDL_Renderer**) da_SDL_CreateWindowAndRenderer;
    alias nothrow SDL_Renderer* function(SDL_Window*, int, Uint32) da_SDL_CreateRenderer;
    alias nothrow SDL_Renderer* function(SDL_Surface*) da_SDL_CreateSoftwareRenderer;
    alias nothrow SDL_Renderer* function(SDL_Window*) da_SDL_GetRenderer;
    alias nothrow int function(SDL_Renderer*, SDL_RendererInfo*) da_SDL_GetRendererInfo;
    alias nothrow SDL_Texture* function(SDL_Renderer*, Uint32, int, int, int) da_SDL_CreateTexture;
    alias nothrow SDL_Texture* function(SDL_Renderer*, SDL_Surface*) da_SDL_CreateTextureFromSurface;
    alias nothrow int function(SDL_Texture*, Uint32*, int*, int*, int*) da_SDL_QueryTexture;
    alias nothrow int function(SDL_Texture*, Uint8, Uint8, Uint8) da_SDL_SetTextureColorMod;
    alias nothrow int function(SDL_Texture*, Uint8*, Uint8*, Uint8*) da_SDL_GetTextureColorMod;
    alias nothrow int function(SDL_Texture*, Uint8) da_SDL_SetTextureAlphaMod;
    alias nothrow int function(SDL_Texture*, Uint8*) da_SDL_GetTextureAlphaMod;
    alias nothrow int function(SDL_Texture*, SDL_BlendMode) da_SDL_SetTextureBlendMode;
    alias nothrow int function(SDL_Texture*, SDL_BlendMode*) da_SDL_GetTextureBlendMode;
    alias nothrow int function(SDL_Texture*, const(SDL_Rect)*, const(void)*, int) da_SDL_UpdateTexture;
    alias nothrow int function(SDL_Texture*, const(SDL_Rect)*, void**, int*) da_SDL_LockTexture;
    alias nothrow int function(SDL_Texture*) da_SDL_UnlockTexture;
    alias nothrow SDL_bool function(SDL_Renderer*) da_SDL_RenderTargetSupported;
    alias nothrow int function(SDL_Renderer*, SDL_Texture*) da_SDL_SetRenderTarget;
    alias nothrow SDL_Texture* function(SDL_Renderer*) da_SDL_GetRenderTarget;
    alias nothrow int function(SDL_Renderer*, int, int) da_SDL_RenderSetLogicalSize;
    alias nothrow void function(SDL_Renderer*, int*, int*) da_SDL_RenderGetLogicalSize;
    alias nothrow int function(SDL_Renderer*, const(SDL_Rect)*) da_SDL_RenderSetViewport;
    alias nothrow void function(SDL_Renderer*, SDL_Rect*) da_SDL_RenderGetViewport;
    alias nothrow int function(SDL_Renderer*, float, float) da_SDL_RenderSetScale;
    alias nothrow int function(SDL_Renderer*, float*, float*) da_SDL_RenderGetScale;
    alias nothrow int function(SDL_Renderer*, Uint8, Uint8, Uint8, Uint8) da_SDL_SetRenderDrawColor;
    alias nothrow int function(SDL_Renderer*, Uint8*, Uint8*, Uint8*, Uint8*) da_SDL_GetRenderDrawColor;
    alias nothrow int function(SDL_Renderer*, SDL_BlendMode) da_SDL_SetRenderDrawBlendMode;
    alias nothrow int function(SDL_Renderer*, SDL_BlendMode*) da_SDL_GetRenderDrawBlendMode;
    alias nothrow int function(SDL_Renderer*) da_SDL_RenderClear;
    alias nothrow int function(SDL_Renderer*, int, int) da_SDL_RenderDrawPoint;
    alias nothrow int function(SDL_Renderer*, const(SDL_Point)*, int) da_SDL_RenderDrawPoints;
    alias nothrow int function(SDL_Renderer*, int, int, int, int) da_SDL_RenderDrawLine;
    alias nothrow int function(SDL_Renderer*, const(SDL_Point)*, int) da_SDL_RenderDrawLines;
    alias nothrow int function(SDL_Renderer*, const(SDL_Rect)*) da_SDL_RenderDrawRect;
    alias nothrow int function(SDL_Renderer*, const(SDL_Rect)*, int) da_SDL_RenderDrawRects;
    alias nothrow int function(SDL_Renderer*, const(SDL_Rect)*) da_SDL_RenderFillRect;
    alias nothrow int function(SDL_Renderer*, const(SDL_Rect)*) da_SDL_RenderFillRects;
    alias nothrow int function(SDL_Renderer*, SDL_Texture*, const(SDL_Rect)*, const(SDL_Rect*)) da_SDL_RenderCopy;
    alias nothrow int function(SDL_Renderer*, SDL_Texture*, const(SDL_Rect)*, const(SDL_Rect)*, const(double), const(SDL_Point)*, const(SDL_RendererFlip)) da_SDL_RenderCopyEx;
    alias nothrow int function(SDL_Renderer*, const(SDL_Rect)*, Uint32, void*, int) da_SDL_RenderReadPixels;
    alias nothrow void function(SDL_Renderer*) da_SDL_RenderPresent;
    alias nothrow void function(SDL_Texture*) da_SDL_DestroyTexture;
    alias nothrow void function(SDL_Renderer*) da_SDL_DestroyRenderer;
    alias nothrow int function(SDL_Texture*, float*, float*) da_SDL_GL_BindTexture;
    alias nothrow int function(SDL_Texture*) da_SDL_GL_UnbindTexture;

    // SDL_rwops.h
    alias nothrow SDL_RWops* function(const(char)*, const(char)*) da_SDL_RWFromFile;
    alias nothrow SDL_RWops* function(FILE*, SDL_bool) da_SDL_RWFromFP;
    alias nothrow SDL_RWops* function(void*, int) da_SDL_RWFromMem;
    alias nothrow SDL_RWops* function(const(void)*, int) da_SDL_RWFromConstMem;
    alias nothrow SDL_RWops* function() da_SDL_AllocRW;
    alias nothrow void function(SDL_RWops*) da_SDL_FreeRW;
    alias nothrow Uint8 function(SDL_RWops*) da_SDL_ReadU8;
    alias nothrow Uint16 function(SDL_RWops*) da_SDL_ReadLE16;
    alias nothrow Uint16 function(SDL_RWops*) da_SDL_ReadBE16;
    alias nothrow Uint32 function(SDL_RWops*) da_SDL_ReadLE32;
    alias nothrow Uint32 function(SDL_RWops*) da_SDL_ReadBE32;
    alias nothrow Uint64 function(SDL_RWops*) da_SDL_ReadLE64;
    alias nothrow Uint64 function(SDL_RWops*) da_SDL_ReadBE64;
    alias nothrow size_t function(SDL_RWops*, Uint8) da_SDL_WriteU8;
    alias nothrow size_t function(SDL_RWops*, Uint16) da_SDL_WriteLE16;
    alias nothrow size_t function(SDL_RWops*, Uint16) da_SDL_WriteBE16;
    alias nothrow size_t function(SDL_RWops*, Uint32) da_SDL_WriteLE32;
    alias nothrow size_t function(SDL_RWops*, Uint32) da_SDL_WriteBE32;
    alias nothrow size_t function(SDL_RWops*, Uint64) da_SDL_WriteLE64;
    alias nothrow size_t function(SDL_RWops*, Uint64) da_SDL_WriteBE64;

    // SDL_shape.h
    alias nothrow SDL_Window* function(const(char)*, uint, uint, uint, uint, Uint32) da_SDL_CreateShapedWindow;
    alias nothrow SDL_bool function(const(SDL_Window)*) da_SDL_IsShapedWindow;
    alias nothrow int function(SDL_Window*, SDL_Surface*, SDL_WindowShapeMode*) da_SDL_SetWindowShape;
    alias nothrow int function(SDL_Window*, SDL_WindowShapeMode*) da_SDL_GetShapedWindowMode;

    // SDL_surface.h
    alias nothrow SDL_Surface* function(Uint32, int, int, int, Uint32, Uint32, Uint32, Uint32) da_SDL_CreateRGBSurface;
    alias nothrow SDL_Surface* function(void*, int, int, int, int, Uint32, Uint32, Uint32, Uint32) da_SDL_CreateRGBSurfaceFrom;
    alias nothrow void function(SDL_Surface*) da_SDL_FreeSurface;
    alias nothrow int function(SDL_Surface*, SDL_Palette*) da_SDL_SetSurfacePalette;
    alias nothrow int function(SDL_Surface*) da_SDL_LockSurface;
    alias nothrow int function(SDL_Surface*) da_SDL_UnlockSurface;
    alias nothrow SDL_Surface* function(SDL_RWops*, int) da_SDL_LoadBMP_RW;
    alias nothrow int function(SDL_Surface*, SDL_RWops*, int) da_SDL_SaveBMP_RW;
    alias nothrow int function(SDL_Surface*, int) da_SDL_SetSurfaceRLE;
    alias nothrow int function(SDL_Surface*, int, Uint32) da_SDL_SetColorKey;
    alias nothrow int function(SDL_Surface*, Uint32*) da_SDL_GetColorKey;
    alias nothrow int function(SDL_Surface*, Uint8, Uint8, Uint8) da_SDL_SetSurfaceColorMod;
    alias nothrow int function(SDL_Surface*, Uint8*, Uint8*, Uint8*) da_SDL_GetSurfaceColorMod;
    alias nothrow int function(SDL_Surface*, Uint8) da_SDL_SetSurfaceAlphaMod;
    alias nothrow int function(SDL_Surface*, Uint8*) da_SDL_GetSurfaceAlphaMod;
    alias nothrow int function(SDL_Surface*, SDL_BlendMode) da_SDL_SetSurfaceBlendMode;
    alias nothrow int function(SDL_Surface*, SDL_BlendMode*) da_SDL_GetSurfaceBlendMode;
    alias nothrow SDL_bool function(SDL_Surface*, const(SDL_Rect)*) da_SDL_SetClipRect;
    alias nothrow void function(SDL_Surface*, SDL_Rect*) da_SDL_GetClipRect;
    alias nothrow SDL_Surface* function(SDL_Surface*, SDL_PixelFormat*, Uint32) da_SDL_ConvertSurface;
    alias nothrow SDL_Surface* function(SDL_Surface*, Uint32, Uint32) da_SDL_ConvertSurfaceFormat;
    alias nothrow int function(int, int, Uint32, const(void)*, int, Uint32, void*, int) da_SDL_ConvertPixels;
    alias nothrow int function(SDL_Surface*, const(SDL_Rect)*, Uint32) da_SDL_FillRect;
    alias nothrow int function(SDL_Surface*, const(SDL_Rect)*, int, Uint32) da_SDL_FillRects;
    alias nothrow SDL_UpperBlit SDL_BlitSurface;
    alias nothrow int function(SDL_Surface*, const(SDL_Rect)*, SDL_Surface*, SDL_Rect*) da_SDL_UpperBlit;
    alias nothrow int function(SDL_Surface*, SDL_Rect*, SDL_Surface*, SDL_Rect*) da_SDL_LowerBlit;
    alias nothrow int function(SDL_Surface*, const(SDL_Rect)*, SDL_Surface*, const(SDL_Rect)*) da_SDL_SoftStretch;
    alias nothrow SDL_UpperBlitScaled SDL_BlitScaled;
    alias nothrow int function(SDL_Surface*, const(SDL_Rect)*, SDL_Surface*, SDL_Rect*) da_SDL_UpperBlitScaled;
    alias nothrow int function(SDL_Surface*, SDL_Rect*, SDL_Surface*, SDL_Rect*) da_SDL_LowerBlitScaled;

    // SDL_timer.h
    alias nothrow Uint32 function() da_SDL_GetTicks;
    alias nothrow Uint64 function() da_SDL_GetPerformanceCounter;
    alias nothrow Uint64 function() da_SDL_GetPerformanceFrequency;
    alias nothrow void function(Uint32) da_SDL_Delay;
    alias nothrow SDL_TimerID function(Uint32, SDL_TimerCallback, void*) da_SDL_AddTimer;
    alias nothrow SDL_bool function(SDL_TimerID) da_SDL_RemoveTimer;

    // SDL_touch.h
    alias nothrow int function() da_SDL_GetNumTouchDevices;
    alias nothrow SDL_TouchID function(int) da_SDL_GetTouchDevice;
    alias nothrow int function(SDL_TouchID) da_SDL_GetNumTouchFingers;
    alias nothrow SDL_Finger* function(SDL_TouchID, int) da_SDL_GetTouchFinger;

    // SDL_version.h
    alias nothrow void function(SDL_version*) da_SDL_GetVersion;
    alias nothrow const(char)* function() da_SDL_GetRevision;
    alias nothrow int function() da_SDL_GetRevisionNumber;

    // SDL_video.h
    alias nothrow int function() da_SDL_GetNumVideoDrivers;
    alias nothrow const(char)* function(int) da_SDL_GetVideoDriver;
    alias nothrow int function(const(char)*) da_SDL_VideoInit;
    alias nothrow void function() da_SDL_VideoQuit;
    alias nothrow const(char)* function() da_SDL_GetCurrentVideoDriver;
    alias nothrow int function() da_SDL_GetNumVideoDisplays;
    alias nothrow int function(int) da_SDL_GetDisplayName;
    alias nothrow int function(int, SDL_Rect*) da_SDL_GetDisplayBounds;
    alias nothrow int function(int) da_SDL_GetNumDisplayModes;
    alias nothrow int function(int, int, SDL_DisplayMode*) da_SDL_GetDisplayMode;
    alias nothrow int function(int, SDL_DisplayMode*) da_SDL_GetDesktopDisplayMode;
    alias nothrow int function(int, SDL_DisplayMode*) da_SDL_GetCurrentDisplayMode;
    alias nothrow SDL_DisplayMode* function(int, const(SDL_DisplayMode)*, SDL_DisplayMode*) da_SDL_GetClosestDisplayMode;
    alias nothrow int function(SDL_Window*) da_SDL_GetWindowDisplayIndex;
    alias nothrow int function(SDL_Window*, const(SDL_DisplayMode)*) da_SDL_SetWindowDisplayMode;
    alias nothrow int function(SDL_Window*, SDL_DisplayMode*) da_SDL_GetWindowDisplayMode;
    alias nothrow Uint32 function(SDL_Window*) da_SDL_GetWindowPixelFormat;
    alias nothrow SDL_Window* function(const(char)*, int, int, int, int, Uint32) da_SDL_CreateWindow;
    alias nothrow SDL_Window* function(const(void)*) da_SDL_CreateWindowFrom;
    alias nothrow Uint32 function(SDL_Window*) da_SDL_GetWindowID;
    alias nothrow SDL_Window* function(Uint32) da_SDL_GetWindowFromID;
    alias nothrow Uint32 function(SDL_Window*) da_SDL_GetWindowFlags;
    alias nothrow void function(SDL_Window*, const(char)*) da_SDL_SetWindowTitle;
    alias nothrow const(char)* function(SDL_Window*) da_SDL_GetWindowTitle;
    alias nothrow void function(SDL_Window*, SDL_Surface*) da_SDL_SetWindowIcon;
    alias nothrow void* function(SDL_Window*, const(char)*, void*) da_SDL_SetWindowData;
    alias nothrow void* function(SDL_Window*, const(char)*) da_SDL_GetWindowData;
    alias nothrow void function(SDL_Window*, int, int) da_SDL_SetWindowPosition;
    alias nothrow void function(SDL_Window*, int*, int*) da_SDL_GetWindowPosition;
    alias nothrow void function(SDL_Window*, int, int) da_SDL_SetWindowSize;
    alias nothrow void function(SDL_Window*, int*, int*) da_SDL_GetWindowSize;
    alias nothrow void function(SDL_Window*, int, int) da_SDL_SetWindowMinimumSize;
    alias nothrow void function(SDL_Window*, int*, int*) da_SDL_GetWindowMinimumSize;
    alias nothrow void function(SDL_Window*, int, int) da_SDL_SetWindowMaximumSize;
    alias nothrow void function(SDL_Window*, int*, int*) da_SDL_GetWindowMaximumSize;
    alias nothrow void function(SDL_Window*, SDL_bool) da_SDL_SetWindowBordered;
    alias nothrow void function(SDL_Window*) da_SDL_ShowWindow;
    alias nothrow void function(SDL_Window*) da_SDL_HideWindow;
    alias nothrow void function(SDL_Window*) da_SDL_RaiseWindow;
    alias nothrow void function(SDL_Window*) da_SDL_MaximizeWindow;
    alias nothrow void function(SDL_Window*) da_SDL_MinimizeWindow;
    alias nothrow void function(SDL_Window*) da_SDL_RestoreWindow;
    alias nothrow int function(SDL_Window*, Uint32) da_SDL_SetWindowFullscreen;
    alias nothrow SDL_Surface* function(SDL_Window*) da_SDL_GetWindowSurface;
    alias nothrow int function(SDL_Window*) da_SDL_UpdateWindowSurface;
    alias nothrow int function(SDL_Window*, SDL_Rect*, int) da_SDL_UpdateWindowSurfaceRects;
    alias nothrow void function(SDL_Window*, SDL_bool) da_SDL_SetWindowGrab;
    alias nothrow SDL_bool function(SDL_Window*) da_SDL_GetWindowGrab;
    alias nothrow int function(SDL_Window*, float) da_SDL_SetWindowBrightness;
    alias nothrow float function(SDL_Window*) da_SDL_GetWindowBrightness;
    alias nothrow int function(SDL_Window*, const(Uint16)*, const(Uint16)*, const(Uint16)*, const(Uint16)*) da_SDL_SetWindowGammaRamp;
    alias nothrow int function(SDL_Window*, Uint16*, Uint16*, Uint16*, Uint16*) da_SDL_GetWindowGammaRamp;
    alias nothrow void function(SDL_Window*) da_SDL_DestroyWindow;
    alias nothrow SDL_bool function() da_SDL_IsScreenSaverEnabled;
    alias nothrow void function() da_SDL_EnableScreenSaver;
    alias nothrow void function() da_SDL_DisableScreenSaver;
    alias nothrow int function(const(char)*) da_SDL_GL_LoadLibrary;
    alias nothrow void* function(const(char)*) da_SDL_GL_GetProcAddress;
    alias nothrow void function() da_SDL_GL_UnloadLibrary;
    alias nothrow SDL_bool function(const(char)*) da_SDL_GL_ExtensionSupported;
    alias nothrow int function(SDL_GLattr, int) da_SDL_GL_SetAttribute;
    alias nothrow int function(SDL_GLattr, int*) da_SDL_GL_GetAttribute;
    alias nothrow SDL_GLContext function(SDL_Window*) da_SDL_GL_CreateContext;
    alias nothrow int function(SDL_Window*, SDL_GLContext) da_SDL_GL_MakeCurrent;
    alias nothrow int function(int) da_SDL_GL_SetSwapInterval;
    alias nothrow int function() da_SDL_GL_GetSwapInterval;
    alias nothrow void function(SDL_Window*) da_SDL_GL_SwapWindow;
    alias nothrow void function(SDL_GLContext) da_SDL_GL_DeleteContext;
}

// SDL_audio.h
nothrow SDL_AudioSpec* SDL_LoadWAV(const(char)* file, SDL_AudioSpec* spec, Uint8** audio_buf, Uint32* len)
{
    return SDL_LoadWAV_RW(SDL_RWFromFile(file, "rb"), 1, spec, audio_buf, len);
}

// SDL_events.h
nothrow Uint8 SDL_GetEventState(Uint32 type)
{
    return SDL_EventState(type, SDL_QUERY);
}

// SDL_quit.h
nothrow bool SDL_QuitRequested()
{
    SDL_PumpEvents();
    return SDL_PeepEvents(null, 0, SDL_PEEKEVENT, SDL_QUIT, SDL_QUIT) > 0;
}

// SDL_surface.h
nothrow SDL_Surface* SDL_LoadBMP(const(char)* file)
{
    return SDL_LoadBMP_RW(SDL_RWFromFile(file, "rb"), 1);
}

nothrow int SDL_SaveBMP(SDL_Surface* surface, const(char)* file)
{
    return SDL_SaveBMP_RW(surface, SDL_RWFromFile(file, "wb"), 1);
}

__gshared
{
    da_SDL_Init SDL_Init;
    da_SDL_InitSubSystem SDL_InitSubSystem;
    da_SDL_QuitSubSystem SDL_QuitSubSystem;
    da_SDL_WasInit SDL_WasInit;
    da_SDL_Quit SDL_Quit;

    da_SDL_GetNumAudioDrivers SDL_GetNumAudioDrivers;
    da_SDL_GetAudioDriver SDL_GetAudioDriver;
    da_SDL_AudioInit SDL_AudioInit;
    da_SDL_AudioQuit SDL_AudioQuit;
    da_SDL_GetCurrentAudioDriver SDL_GetCurrentAudioDriver;
    da_SDL_OpenAudio SDL_OpenAudio;
    da_SDL_GetNumAudioDevices SDL_GetNumAudioDevices;
    da_SDL_GetAudioDeviceName SDL_GetAudioDeviceName;
    da_SDL_OpenAudioDevice SDL_OpenAudioDevice;
    da_SDL_GetAudioStatus SDL_GetAudioStatus;
    da_SDL_GetAudioDeviceStatus SDL_GetAudioDeviceStatus;
    da_SDL_PauseAudio SDL_PauseAudio;
    da_SDL_PauseAudioDevice SDL_PauseAudioDevice;
    da_SDL_LoadWAV_RW SDL_LoadWAV_RW;
    da_SDL_FreeWAV SDL_FreeWAV;
    da_SDL_BuildAudioCVT SDL_BuildAudioCVT;
    da_SDL_ConvertAudio SDL_ConvertAudio;
    da_SDL_MixAudio SDL_MixAudio;
    da_SDL_MixAudioFormat SDL_MixAudioFormat;
    da_SDL_LockAudio SDL_LockAudio;
    da_SDL_LockAudioDevice SDL_LockAudioDevice;
    da_SDL_UnlockAudio SDL_UnlockAudio;
    da_SDL_UnlockAudioDevice SDL_UnlockAudioDevice;
    da_SDL_CloseAudio SDL_CloseAudio;
    da_SDL_CloseAudioDevice SDL_CloseAudioDevice;
//    da_SDL_AudioDeviceConnected SDL_AudioDeviceConnected;

    da_SDL_SetClipboardText SDL_SetClipboardText;
    da_SDL_GetClipboardText SDL_GetClipboardText;
    da_SDL_HasClipboardText SDL_HasClipboardText;

    da_SDL_GetCPUCount SDL_GetCPUCount;
    da_SDL_GetCPUCacheLineSize SDL_GetCPUCacheLineSize;
    da_SDL_HasRDTSC SDL_HasRDTSC;
    da_SDL_HasAltiVec SDL_HasAltiVec;
    da_SDL_HasMMX SDL_HasMMX;
    da_SDL_Has3DNow SDL_Has3DNow;
    da_SDL_HasSSE SDL_HasSSE;
    da_SDL_HasSSE2 SDL_HasSSE2;
    da_SDL_HasSSE3 SDL_HasSSE3;
    da_SDL_HasSSE41 SDL_HasSSE41;
    da_SDL_HasSSE42 SDL_HasSSE42;

    da_SDL_SetError SDL_SetError;
    da_SDL_GetError SDL_GetError;
    da_SDL_ClearError SDL_ClearError;

    da_SDL_PumpEvents SDL_PumpEvents;
    da_SDL_PeepEvents SDL_PeepEvents;
    da_SDL_HasEvent SDL_HasEvent;
    da_SDL_HasEvents SDL_HasEvents;
    da_SDL_FlushEvent SDL_FlushEvent;
    da_SDL_FlushEvents SDL_FlushEvents;
    da_SDL_PollEvent SDL_PollEvent;
    da_SDL_WaitEvent SDL_WaitEvent;
    da_SDL_WaitEventTimeout SDL_WaitEventTimeout;
    da_SDL_PushEvent SDL_PushEvent;
    da_SDL_SetEventFilter SDL_SetEventFilter;
    da_SDL_GetEventFilter SDL_GetEventFilter;
    da_SDL_AddEventWatch SDL_AddEventWatch;
    da_SDL_DelEventWatch SDL_DelEventWatch;
    da_SDL_FilterEvents SDL_FilterEvents;
    da_SDL_EventState SDL_EventState;
    da_SDL_RegisterEvents SDL_RegisterEvents;

    da_SDL_GameControllerAddMapping SDL_GameControllerAddMapping;
    da_SDL_GameControllerMappingForGUID SDL_GameControllerMappingForGUID;
    da_SDL_GameControllerMapping SDL_GameControllerMapping;
    da_SDL_IsGameController SDL_IsGameController;
    da_SDL_GameControllerNameForIndex SDL_GameControllerNameForIndex;
    da_SDL_GameControllerOpen SDL_GameControllerOpen;
    da_SDL_GameControllerName SDL_GameControllerName;
    da_SDL_GameControllerGetAttached SDL_GameControllerGetAttached;
    da_SDL_GameControllerGetJoystick SDL_GameControllerGetJoystick;
    da_SDL_GameControllerEventState SDL_GameControllerEventState;
    da_SDL_GameControllerUpdate SDL_GameControllerUpdate;
    da_SDL_GameControllerGetAxisFromString SDL_GameControllerGetAxisFromString;
    da_SDL_GameControllerGetStringForAxis SDL_GameControllerGetStringForAxis;
    da_SDL_GameControllerGetBindForAxis SDL_GameControllerGetBindForAxis;
    da_SDL_GameControllerGetAxis SDL_GameControllerGetAxis;
    da_SDL_GameControllerGetButtonFromString SDL_GameControllerGetButtonFromString;
    da_SDL_GameControllerGetStringForButton SDL_GameControllerGetStringForButton;
    da_SDL_GameControllerGetBindForButton SDL_GameControllerGetBindForButton;
    da_SDL_GameControllerGetButton SDL_GameControllerGetButton;
    da_SDL_GameControllerClose SDL_GameControllerClose;

    da_SDL_RecordGesture SDL_RecordGesture;
    da_SDL_SaveAllDollarTemplates SDL_SaveAllDollarTemplates;
    da_SDL_SaveDollarTemplate SDL_SaveDollarTemplate;
    da_SDL_LoadDollarTemplates SDL_LoadDollarTemplates;

    da_SDL_NumHaptics SDL_NumHaptics;
    da_SDL_HapticName SDL_HapticName;
    da_SDL_HapticOpen SDL_HapticOpen;
    da_SDL_HapticOpened SDL_HapticOpened;
    da_SDL_HapticIndex SDL_HapticIndex;
    da_SDL_MouseIsHaptic SDL_MouseIsHaptic;
    da_SDL_HapticOpenFromMouse SDL_HapticOpenFromMouse;
    da_SDL_JoystickIsHaptic SDL_JoystickIsHaptic;
    da_SDL_HapticOpenFromJoystick SDL_HapticOpenFromJoystick;
    da_SDL_HapticClose SDL_HapticClose;
    da_SDL_HapticNumEffects SDL_HapticNumEffects;
    da_SDL_HapticNumEffectsPlaying SDL_HapticNumEffectsPlaying;
    da_SDL_HapticQuery SDL_HapticQuery;
    da_SDL_HapticNumAxes SDL_HapticNumAxes;
    da_SDL_HapticEffectSupported SDL_HapticEffectSupported;
    da_SDL_HapticNewEffect SDL_HapticNewEffect;
    da_SDL_HapticUpdateEffect SDL_HapticUpdateEffect;
    da_SDL_HapticRunEffect SDL_HapticRunEffect;
    da_SDL_HapticStopEffect SDL_HapticStopEffect;
    da_SDL_HapticDestroyEffect SDL_HapticDestroyEffect;
    da_SDL_HapticGetEffectStatus SDL_HapticGetEffectStatus;
    da_SDL_HapticSetGain SDL_HapticSetGain;
    da_SDL_HapticSetAutocenter SDL_HapticSetAutocenter;
    da_SDL_HapticPause SDL_HapticPause;
    da_SDL_HapticUnpause SDL_HapticUnpause;
    da_SDL_HapticStopAll SDL_HapticStopAll;
    da_SDL_HapticRumbleSupported SDL_HapticRumbleSupported;
    da_SDL_HapticRumbleInit SDL_HapticRumbleInit;
    da_SDL_HapticRumblePlay SDL_HapticRumblePlay;
    da_SDL_HapticRumbleStop SDL_HapticRumbleStop;

    da_SDL_SetHintWithPriority SDL_SetHintWithPriority;
    da_SDL_SetHint SDL_SetHint;
    da_SDL_GetHint SDL_GetHint;
    da_SDL_ClearHints SDL_ClearHints;

//    da_SDL_RedetectInputDevices SDL_RedetectInputDevices;
//    da_SDL_GetNumInputDevices SDL_GetNumInputDevices;
//    da_SDL_GetInputDeviceName SDL_GetInputDeviceName;
    da_SDL_IsDeviceDisconnected SDL_IsDeviceDisconnected;

    da_SDL_NumJoysticks SDL_NumJoysticks;
    da_SDL_JoystickNameForIndex SDL_JoystickNameForIndex;
    da_SDL_JoystickOpen SDL_JoystickOpen;
    da_SDL_JoystickName SDL_JoystickName;
    da_SDL_JoystickGetDeviceGUID SDL_JoystickGetDeviceGUID;
    da_SDL_JoystickGetGUID SDL_JoystickGetGUID;
    da_SDL_JoystickGetGUIDString SDL_JoystickGetGUIDString;
    da_SDL_JoystickGetGUIDFromString SDL_JoystickGetGUIDFromString;
    da_SDL_JoystickGetAttached SDL_JoystickGetAttached;
    da_SDL_JoystickInstanceID SDL_JoystickInstanceID;
    da_SDL_JoystickNumAxes SDL_JoystickNumAxes;
    da_SDL_JoystickNumBalls SDL_JoystickNumBalls;
    da_SDL_JoystickNumHats SDL_JoystickNumHats;
    da_SDL_JoystickNumButtons SDL_JoystickNumButtons;
    da_SDL_JoystickUpdate SDL_JoystickUpdate;
    da_SDL_JoystickEventState SDL_JoystickEventState;
    da_SDL_JoystickGetAxis SDL_JoystickGetAxis;
    da_SDL_JoystickGetHat SDL_JoystickGetHat;
    da_SDL_JoystickGetBall SDL_JoystickGetBall;
    da_SDL_JoystickGetButton SDL_JoystickGetButton;
    da_SDL_JoystickClose SDL_JoystickClose;

    da_SDL_GetKeyboardFocus SDL_GetKeyboardFocus;
    da_SDL_GetKeyboardState SDL_GetKeyboardState;
    da_SDL_GetModState SDL_GetModState;
    da_SDL_SetModState SDL_SetModState;
    da_SDL_GetKeyFromScancode SDL_GetKeyFromScancode;
    da_SDL_GetScancodeFromKey SDL_GetScancodeFromKey;
    da_SDL_GetScancodeName SDL_GetScancodeName;
    da_SDL_GetScancodeFromName SDL_GetScancodeFromName;
    da_SDL_GetKeyName SDL_GetKeyName;
    da_SDL_GetKeyFromName SDL_GetKeyFromName;
    da_SDL_StartTextInput SDL_StartTextInput;
    da_SDL_IsTextInputActive SDL_IsTextInputActive;
    da_SDL_StopTextInput SDL_StopTextInput;
    da_SDL_SetTextInputRect SDL_SetTextInputRect;
    da_SDL_HasScreenKeyboardSupport SDL_HasScreenKeyboardSupport;
    da_SDL_IsScreenKeyboardShown SDL_IsScreenKeyboardShown;

    da_SDL_LoadObject SDL_LoadObject;
    da_SDL_LoadFunction SDL_LoadFunction;
    da_SDL_UnloadObject SDL_UnloadObject;

    da_SDL_LogSetAllPriority SDL_LogSetAllPriority;
    da_SDL_LogSetPriority SDL_LogSetPriority;
    da_SDL_LogGetPriority SDL_LogGetPriority;
    da_SDL_LogResetPriorities SDL_LogResetPriorities;
    da_SDL_Log SDL_Log;
    da_SDL_LogVerbose SDL_LogVerbose;
    da_SDL_LogDebug SDL_LogDebug;
    da_SDL_LogInfo SDL_LogInfo;
    da_SDL_LogWarn SDL_LogWarn;
    da_SDL_LogError SDL_LogError;
    da_SDL_LogCritical SDL_LogCritical;
    da_SDL_LogMessage SDL_LogMessage;
    da_SDL_LogMessageV SDL_LogMessageV;
    da_SDL_LogGetOutputFunction SDL_LogGetOutputFunction;
    da_SDL_LogSetOutputFunction SDL_LogSetOutputFunction;

    da_SDL_ShowMessageBox SDL_ShowMessageBox;
    da_SDL_ShowSimpleMessageBox SDL_ShowSimpleMessageBox;

    da_SDL_GetMouseFocus SDL_GetMouseFocus;
    da_SDL_GetMouseState SDL_GetMouseState;
    da_SDL_GetRelativeMouseState SDL_GetRelativeMouseState;
    da_SDL_WarpMouseInWindow SDL_WarpMouseInWindow;
    da_SDL_SetRelativeMouseMode SDL_SetRelativeMouseMode;
    da_SDL_GetRelativeMouseMode SDL_GetRelativeMouseMode;
    da_SDL_CreateCursor SDL_CreateCursor;
    da_SDL_CreateColorCursor SDL_CreateColorCursor;
    da_SDL_CreateSystemCursor SDL_CreateSystemCursor;
    da_SDL_SetCursor SDL_SetCursor;
    da_SDL_GetCursor SDL_GetCursor;
    da_SDL_FreeCursor SDL_FreeCursor;
    da_SDL_ShowCursor SDL_ShowCursor;

    da_SDL_GetPixelFormatName SDL_GetPixelFormatName;
    da_SDL_PixelFormatEnumToMasks SDL_PixelFormatEnumToMasks;
    da_SDL_MasksToPixelFormatEnum SDL_MasksToPixelFormatEnum;
    da_SDL_AllocFormat SDL_AllocFormat;
    da_SDL_FreeFormat SDL_FreeFormat;
    da_SDL_AllocPalette SDL_AllocPalette;
    da_SDL_SetPixelFormatPalette SDL_SetPixelFormatPalette;
    da_SDL_SetPaletteColors SDL_SetPaletteColors;
    da_SDL_FreePalette SDL_FreePalette;
    da_SDL_MapRGB SDL_MapRGB;
    da_SDL_MapRGBA SDL_MapRGBA;
    da_SDL_GetRGB SDL_GetRGB;
    da_SDL_GetRGBA SDL_GetRGBA;
    da_SDL_CalculateGammaRamp SDL_CalculateGammaRamp;

    da_SDL_GetPlatform SDL_GetPlatform;

    da_SDL_GetPowerInfo SDL_GetPowerInfo;

    da_SDL_HasIntersection SDL_HasIntersection;
    da_SDL_IntersectRect SDL_IntersectRect;
    da_SDL_UnionRect SDL_UnionRect;
    da_SDL_EnclosePoints SDL_EnclosePoints;
    da_SDL_IntersectRectAndLine SDL_IntersectRectAndLine;

    da_SDL_GetNumRenderDrivers SDL_GetNumRenderDrivers;
    da_SDL_GetRenderDriverInfo SDL_GetRenderDriverInfo;
    da_SDL_CreateWindowAndRenderer SDL_CreateWindowAndRenderer;
    da_SDL_CreateRenderer SDL_CreateRenderer;
    da_SDL_CreateSoftwareRenderer SDL_CreateSoftwareRenderer;
    da_SDL_GetRenderer SDL_GetRenderer;
    da_SDL_GetRendererInfo SDL_GetRendererInfo;
    da_SDL_CreateTexture SDL_CreateTexture;
    da_SDL_CreateTextureFromSurface SDL_CreateTextureFromSurface;
    da_SDL_QueryTexture SDL_QueryTexture;
    da_SDL_SetTextureColorMod SDL_SetTextureColorMod;
    da_SDL_GetTextureColorMod SDL_GetTextureColorMod;
    da_SDL_SetTextureAlphaMod SDL_SetTextureAlphaMod;
    da_SDL_GetTextureAlphaMod SDL_GetTextureAlphaMod;
    da_SDL_SetTextureBlendMode SDL_SetTextureBlendMode;
    da_SDL_GetTextureBlendMode SDL_GetTextureBlendMode;
    da_SDL_UpdateTexture SDL_UpdateTexture;
    da_SDL_LockTexture SDL_LockTexture;
    da_SDL_UnlockTexture SDL_UnlockTexture;
    da_SDL_RenderTargetSupported SDL_RenderTargetSupported;
    da_SDL_SetRenderTarget SDL_SetRenderTarget;
    da_SDL_GetRenderTarget SDL_GetRenderTarget;
    da_SDL_RenderSetLogicalSize SDL_RenderSetLogicalSize;
    da_SDL_RenderGetLogicalSize SDL_RenderGetLogicalSize;
    da_SDL_RenderSetViewport SDL_RenderSetViewport;
    da_SDL_RenderGetViewport SDL_RenderGetViewport;
    da_SDL_RenderSetScale SDL_RenderSetScale;
    da_SDL_RenderGetScale SDL_RenderGetScale;
    da_SDL_SetRenderDrawColor SDL_SetRenderDrawColor;
    da_SDL_GetRenderDrawColor SDL_GetRenderDrawColor;
    da_SDL_SetRenderDrawBlendMode SDL_SetRenderDrawBlendMode;
    da_SDL_GetRenderDrawBlendMode SDL_GetRenderDrawBlendMode;
    da_SDL_RenderClear SDL_RenderClear;
    da_SDL_RenderDrawPoint SDL_RenderDrawPoint;
    da_SDL_RenderDrawPoints SDL_RenderDrawPoints;
    da_SDL_RenderDrawLine SDL_RenderDrawLine;
    da_SDL_RenderDrawLines SDL_RenderDrawLines;
    da_SDL_RenderDrawRect SDL_RenderDrawRect;
    da_SDL_RenderDrawRects SDL_RenderDrawRects;
    da_SDL_RenderFillRect SDL_RenderFillRect;
    da_SDL_RenderFillRects SDL_RenderFillRects;
    da_SDL_RenderCopy SDL_RenderCopy;
    da_SDL_RenderCopyEx SDL_RenderCopyEx;
    da_SDL_RenderReadPixels SDL_RenderReadPixels;
    da_SDL_RenderPresent SDL_RenderPresent;
    da_SDL_DestroyTexture SDL_DestroyTexture;
    da_SDL_DestroyRenderer SDL_DestroyRenderer;
    da_SDL_GL_BindTexture SDL_GL_BindTexture;
    da_SDL_GL_UnbindTexture SDL_GL_UnbindTexture;

    da_SDL_RWFromFile SDL_RWFromFile;
    da_SDL_RWFromFP SDL_RWFromFP;
    da_SDL_RWFromMem SDL_RWFromMem;
    da_SDL_RWFromConstMem SDL_RWFromConstMem;
    da_SDL_AllocRW SDL_AllocRW;
    da_SDL_FreeRW SDL_FreeRW;
    da_SDL_ReadU8 SDL_ReadU8;
    da_SDL_ReadLE16 SDL_ReadLE16;
    da_SDL_ReadBE16 SDL_ReadBE16;
    da_SDL_ReadLE32 SDL_ReadLE32;
    da_SDL_ReadBE32 SDL_ReadBE32;
    da_SDL_ReadLE64 SDL_ReadLE64;
    da_SDL_ReadBE64 SDL_ReadBE64;
    da_SDL_WriteU8 SDL_WriteU8;
    da_SDL_WriteLE16 SDL_WriteLE16;
    da_SDL_WriteBE16 SDL_WriteBE16;
    da_SDL_WriteLE32 SDL_WriteLE32;
    da_SDL_WriteBE32 SDL_WriteBE32;
    da_SDL_WriteLE64 SDL_WriteLE64;
    da_SDL_WriteBE64 SDL_WriteBE64;

    da_SDL_CreateShapedWindow SDL_CreateShapedWindow;
    da_SDL_IsShapedWindow SDL_IsShapedWindow;
    da_SDL_SetWindowShape SDL_SetWindowShape;
    da_SDL_GetShapedWindowMode SDL_GetShapedWindowMode;

    da_SDL_CreateRGBSurface SDL_CreateRGBSurface;
    da_SDL_CreateRGBSurfaceFrom SDL_CreateRGBSurfaceFrom;
    da_SDL_FreeSurface SDL_FreeSurface;
    da_SDL_SetSurfacePalette SDL_SetSurfacePalette;
    da_SDL_LockSurface SDL_LockSurface;
    da_SDL_UnlockSurface SDL_UnlockSurface;
    da_SDL_LoadBMP_RW SDL_LoadBMP_RW;
    da_SDL_SaveBMP_RW SDL_SaveBMP_RW;
    da_SDL_SetSurfaceRLE SDL_SetSurfaceRLE;
    da_SDL_SetColorKey SDL_SetColorKey;
    da_SDL_GetColorKey SDL_GetColorKey;
    da_SDL_SetSurfaceColorMod SDL_SetSurfaceColorMod;
    da_SDL_GetSurfaceColorMod SDL_GetSurfaceColorMod;
    da_SDL_SetSurfaceAlphaMod SDL_SetSurfaceAlphaMod;
    da_SDL_GetSurfaceAlphaMod SDL_GetSurfaceAlphaMod;
    da_SDL_SetSurfaceBlendMode SDL_SetSurfaceBlendMode;
    da_SDL_GetSurfaceBlendMode SDL_GetSurfaceBlendMode;
    da_SDL_SetClipRect SDL_SetClipRect;
    da_SDL_GetClipRect SDL_GetClipRect;
    da_SDL_ConvertSurface SDL_ConvertSurface;
    da_SDL_ConvertSurfaceFormat SDL_ConvertSurfaceFormat;
    da_SDL_ConvertPixels SDL_ConvertPixels;
    da_SDL_FillRect SDL_FillRect;
    da_SDL_FillRects SDL_FillRects;
    da_SDL_UpperBlit SDL_UpperBlit;
    da_SDL_LowerBlit SDL_LowerBlit;
    da_SDL_SoftStretch SDL_SoftStretch;
    da_SDL_UpperBlitScaled SDL_UpperBlitScaled;
    da_SDL_LowerBlitScaled SDL_LowerBlitScaled;

    da_SDL_GetTicks SDL_GetTicks;
    da_SDL_GetPerformanceCounter SDL_GetPerformanceCounter;
    da_SDL_GetPerformanceFrequency SDL_GetPerformanceFrequency;
    da_SDL_Delay SDL_Delay;
    da_SDL_AddTimer SDL_AddTimer;

    da_SDL_GetNumTouchDevices SDL_GetNumTouchDevices;
    da_SDL_GetTouchDevice SDL_GetTouchDevice;
    da_SDL_GetNumTouchFingers SDL_GetNumTouchFingers;
    da_SDL_GetTouchFinger SDL_GetTouchFinger;

    da_SDL_GetVersion SDL_GetVersion;
    da_SDL_GetRevision SDL_GetRevision;
    da_SDL_GetRevisionNumber SDL_GetRevisionNumber;

    da_SDL_GetNumVideoDrivers SDL_GetNumVideoDrivers;
    da_SDL_GetVideoDriver SDL_GetVideoDriver;
    da_SDL_VideoInit SDL_VideoInit;
    da_SDL_VideoQuit SDL_VideoQuit;
    da_SDL_GetCurrentVideoDriver SDL_GetCurrentVideoDriver;
    da_SDL_GetNumVideoDisplays SDL_GetNumVideoDisplays;
    da_SDL_GetDisplayName SDL_GetDisplayName;
    da_SDL_GetDisplayBounds SDL_GetDisplayBounds;
    da_SDL_GetNumDisplayModes SDL_GetNumDisplayModes;
    da_SDL_GetDisplayMode SDL_GetDisplayMode;
    da_SDL_GetDesktopDisplayMode SDL_GetDesktopDisplayMode;
    da_SDL_GetCurrentDisplayMode SDL_GetCurrentDisplayMode;
    da_SDL_GetClosestDisplayMode SDL_GetClosestDisplayMode;
    da_SDL_GetWindowDisplayIndex SDL_GetWindowDisplayIndex;
    da_SDL_SetWindowDisplayMode SDL_SetWindowDisplayMode;
    da_SDL_GetWindowDisplayMode SDL_GetWindowDisplayMode;
    da_SDL_GetWindowPixelFormat SDL_GetWindowPixelFormat;
    da_SDL_CreateWindow SDL_CreateWindow;
    da_SDL_CreateWindowFrom SDL_CreateWindowFrom;
    da_SDL_GetWindowID SDL_GetWindowID;
    da_SDL_GetWindowFromID SDL_GetWindowFromID;
    da_SDL_GetWindowFlags SDL_GetWindowFlags;
    da_SDL_SetWindowTitle SDL_SetWindowTitle;
    da_SDL_GetWindowTitle SDL_GetWindowTitle;
    da_SDL_SetWindowIcon SDL_SetWindowIcon;
    da_SDL_SetWindowData SDL_SetWindowData;
    da_SDL_GetWindowData SDL_GetWindowData;
    da_SDL_SetWindowPosition SDL_SetWindowPosition;
    da_SDL_GetWindowPosition SDL_GetWindowPosition;
    da_SDL_SetWindowSize SDL_SetWindowSize;
    da_SDL_GetWindowSize SDL_GetWindowSize;
    da_SDL_SetWindowMinimumSize SDL_SetWindowMinimumSize;
    da_SDL_GetWindowMinimumSize SDL_GetWindowMinimumSize;
    da_SDL_SetWindowMaximumSize SDL_SetWindowMaximumSize;
    da_SDL_GetWindowMaximumSize SDL_GetWindowMaximumSize;
    da_SDL_SetWindowBordered SDL_SetWindowBordered;
    da_SDL_ShowWindow SDL_ShowWindow;
    da_SDL_HideWindow SDL_HideWindow;
    da_SDL_RaiseWindow SDL_RaiseWindow;
    da_SDL_MaximizeWindow SDL_MaximizeWindow;
    da_SDL_MinimizeWindow SDL_MinimizeWindow;
    da_SDL_RestoreWindow SDL_RestoreWindow;
    da_SDL_SetWindowFullscreen SDL_SetWindowFullscreen;
    da_SDL_GetWindowSurface SDL_GetWindowSurface;
    da_SDL_UpdateWindowSurface SDL_UpdateWindowSurface;
    da_SDL_UpdateWindowSurfaceRects SDL_UpdateWindowSurfaceRects;
    da_SDL_SetWindowGrab SDL_SetWindowGrab;
    da_SDL_GetWindowGrab SDL_GetWindowGrab;
    da_SDL_SetWindowBrightness SDL_SetWindowBrightness;
    da_SDL_GetWindowBrightness SDL_GetWindowBrightness;
    da_SDL_SetWindowGammaRamp SDL_SetWindowGammaRamp;
    da_SDL_GetWindowGammaRamp SDL_GetWindowGammaRamp;
    da_SDL_DestroyWindow SDL_DestroyWindow;
    da_SDL_IsScreenSaverEnabled SDL_IsScreenSaverEnabled;
    da_SDL_EnableScreenSaver SDL_EnableScreenSaver;
    da_SDL_DisableScreenSaver SDL_DisableScreenSaver;
    da_SDL_GL_LoadLibrary SDL_GL_LoadLibrary;
    da_SDL_GL_GetProcAddress SDL_GL_GetProcAddress;
    da_SDL_GL_UnloadLibrary SDL_GL_UnloadLibrary;
    da_SDL_GL_ExtensionSupported SDL_GL_ExtensionSupported;
    da_SDL_GL_SetAttribute SDL_GL_SetAttribute;
    da_SDL_GL_GetAttribute SDL_GL_GetAttribute;
    da_SDL_GL_CreateContext SDL_GL_CreateContext;
    da_SDL_GL_MakeCurrent SDL_GL_MakeCurrent;
    da_SDL_GL_SetSwapInterval SDL_GL_SetSwapInterval;
    da_SDL_GL_GetSwapInterval SDL_GL_GetSwapInterval;
    da_SDL_GL_SwapWindow SDL_GL_SwapWindow;
    da_SDL_GL_DeleteContext SDL_GL_DeleteContext;
}

