module rayd.tracer;

private {
    import gl3n.linalg;
    import rayd.scene;
}



class Ray
{
    this(vec3 origin, vec3 direction)
    {
        m_Origin = origin;
        m_Direction = direction.normalized;
    }

    @property const vec3 Origin()
    {
        return m_Origin;
    }
    @property const vec3 Direction()
    {
        return m_Direction;
    }

private {
    vec3    m_Origin;
    vec3    m_Direction;
}
}


class Tracer
{
    this()
    {
    }
    ~this()
    {
    }

    void Render(Scene scene, uint* image, int width, int height)
    {
        const float camera_dist = 4.0f;
        const float minimum = -1.0f * camera_dist;
        const float maximum = 1.0f * camera_dist;
        float aspect = cast(float)width / cast(float)height;

        float deltaX = (maximum - minimum) / cast(float)width * aspect;
        float deltaY = (maximum - minimum) / cast(float)height;

        vec3 camPos = vec3(0.0f, 0.0f, -5.0f);

        float sy = minimum;
        for (int y = 0; y < height; ++y)
        {
            float sx = minimum;
            for (int x = 0; x < width; ++x)
            {
                vec3 dir = (vec3(sx, sy, 0.0f) - camPos).normalized();
                Ray ray = new Ray(camPos, dir);

                float distance = 1000000.0f;
                vec3 color = this.Trace(scene, ray, distance);
                int r = cast(int)(color.r * 255.0f);
                int g = cast(int)(color.g * 255.0f);
                int b = cast(int)(color.b * 255.0f);

                image[x + (height - y - 1) * width] = 0xff000000 | (b << 16) | (g << 8) | r;

                sx += deltaX;
            }

            sy += deltaY;
        }
    }


private {
    vec3 Trace(Scene scene, in Ray ray, ref float distance)
    {
        vec3 result = vec3(0.0f, 0.0f, 0.0f);

        foreach (prim; scene.Primitives)
        {
            if (prim.Intersection(ray, distance))
            {
                result = prim.Color;
            }
        }

        return result;
    }
}
}
