module rayd.app;

private {
    import derelict.sdl2.sdl;
    import rayd.tracer;
    import rayd.scene;
}

class Application
{
private {
    enum kWndWidth = 800;
    enum kWndHeight = 600;
}

    this()
    {
        m_Window = null;
        m_Renderer = null;
        m_Surface = null;
        m_Runing = false;
    }

    ~this()
    {
    }

    bool Initialize()
    {
        bool success = false;

        DerelictSDL2.load();

        if (SDL_Init(SDL_INIT_VIDEO) >= 0)
        {
            m_Window = SDL_CreateWindow("RayD - part 2", 100, 100, kWndWidth, kWndHeight, SDL_WINDOW_SHOWN);
            if (null != m_Window)
            {
                m_Renderer = SDL_CreateRenderer(m_Window, -1, SDL_RENDERER_SOFTWARE);
                m_Surface = SDL_CreateRGBSurface(0, kWndWidth, kWndHeight, 32, 0xff, 0xff00, 0xff0000, 0xff000000);
                if (null != m_Renderer && null != m_Surface)
                {
                    success = true;
                }
            }
        }

        if (success)
        {
            m_Tracer = new Tracer();
            m_Scene = new Scene();

            m_Scene.Load("_data/scene.json");
        }

        return success;
    }

    void Run()
    {
        m_Runing = true;

        while (m_Runing)
        {
            SDL_Event event;
            while (SDL_PollEvent(&event))
            {
                this.OnEvent(event);
            }

            this.OnRender();
        }
    }

    void Destroy()
    {
        SDL_DestroyRenderer(m_Renderer);
        SDL_DestroyWindow(m_Window);
    }


private {
    void OnEvent(SDL_Event event)
    {
        if (event.type == SDL_QUIT)
            m_Runing = false;
    }

    void OnRender()
    {
        SDL_LockSurface(m_Surface);

        uint* image = cast(uint*)m_Surface.pixels;
        m_Tracer.Render(m_Scene, image, m_Surface.w, m_Surface.h);

        SDL_UnlockSurface(m_Surface);

        SDL_Texture* tex = SDL_CreateTextureFromSurface(m_Renderer, m_Surface);
        SDL_RenderCopy(m_Renderer, tex, null, null);
        SDL_RenderPresent(m_Renderer);

        SDL_DestroyTexture(tex);
    }
}


private {
    SDL_Window*     m_Window;
    SDL_Renderer*   m_Renderer;
    SDL_Surface*    m_Surface;
    bool            m_Runing;

    Tracer          m_Tracer;
    Scene           m_Scene;
}
}
