module rayd.app;

private {
    import derelict.sdl2.sdl;
}

class Application
{
private {
    enum kWndWidth = 800;
    enum kWndHeight = 600;
}

    this()
    {
        m_Window = null;
        m_Renderer = null;
        m_Surface = null;
        m_Runing = false;
    }

    ~this()
    {
    }

    bool Initialize()
    {
        bool success = false;

        DerelictSDL2.load();

        if (SDL_Init(SDL_INIT_VIDEO) >= 0)
        {
            m_Window = SDL_CreateWindow("RayD - part 1", 100, 100, kWndWidth, kWndHeight, SDL_WINDOW_SHOWN);
            if (null != m_Window)
            {
                m_Renderer = SDL_CreateRenderer(m_Window, -1, SDL_RENDERER_SOFTWARE);
                m_Surface = SDL_CreateRGBSurface(0, kWndWidth, kWndHeight, 32, 0xff, 0xff00, 0xff0000, 0xff000000);
                if (null != m_Renderer && null != m_Surface)
                {
                    success = true;
                }
            }
        }

        return success;
    }

    void Run()
    {
        m_Runing = true;

        SDL_Event event;
        while (m_Runing)
        {
            while (SDL_PollEvent(&event))
            {
                this.OnEvent(event);
            }

            this.OnRender();
        }
    }

    void Destroy()
    {
        SDL_DestroyRenderer(m_Renderer);
        SDL_DestroyWindow(m_Window);
    }


private {
    void OnEvent(SDL_Event event)
    {
        if (event.type == SDL_QUIT)
            m_Runing = false;
    }

    void OnRender()
    {
        SDL_LockSurface(m_Surface);

        uint* image = cast(uint*)m_Surface.pixels;
        for (int i = 0; i < m_Surface.w * m_Surface.h; ++i)
        {
            image[i] = 0xff0099ff;
        }

        SDL_UnlockSurface(m_Surface);

        SDL_Texture* tex = SDL_CreateTextureFromSurface(m_Renderer, m_Surface);
        SDL_RenderCopy(m_Renderer, tex, null, null);
        SDL_RenderPresent(m_Renderer);

        SDL_DestroyTexture(tex);
    }
}


private {
    SDL_Window*     m_Window;
    SDL_Renderer*   m_Renderer;
    SDL_Surface*    m_Surface;
    bool            m_Runing;
}
}
