#ifndef __THEORAPLAYER_H__
#define __THEORAPLAYER_H__
#if _MSC_VER > 1000
#	pragma once
#endif	// #if _MSC_VER > 1000

#include <ogg/ogg.h>
#include <theora/theora.h>
#include <theora/theoradec.h>
#include <string>
#include <stdio.h>

class TheoraPlayer
{
public:
	TheoraPlayer();
	~TheoraPlayer();

	// iOrange - opens video from file using "fileName", return true if all is ok, false if not
	bool OpenVideoFile(const std::string& fileName);

	// iOrange - return video frame width
	int GetFrameWidth(void) const;

	// iOrange - return video frame height
	int GetFrameHeight(void) const;

	// iOrange - return video frequency in frames-per-second (FPS)
	float GetFramesPerSecond(void) const;

	// iOrange - advance video playing by "dt" milliseconds
	uint32 Advance(unsigned int dt);

	// iOrange - return true if video is not playing
	bool IsStopped(void) const;

	// iOrange - extract current frame to RGB color space using CPU for yuv-rgb conversion (integer optimization)
	void GetFrameRGB(char* outFrame, int pitch);

	// iOrange - extract current frame to planar YUV444 (de-interlaced yuv) to perform yuv-rgb conversion on GPU
	void GetFrameYUV444(char* outFrame, int pitch);

private:
	// iOrange - internal open file routines
	bool OpenFile(const std::string& fileName);

	// iOrange - buffer some data from file into Ogg stream
	int BufferData(void);

	// iOrange - decodes current frame from Theora to YUV
	void DecodeVideoFrame(void);

private:
	bool		m_VideoOpened;
	FILE*		m_File;
	uint32		m_VideoTimer;
	uint32		m_LastVideoFrame;
	int			m_FrameWidth;
	int			m_FrameHeight;
	float		m_FramesPerSecond;
	bool		m_Stopped;

	/* Ogg stuff */
	ogg_sync_state		m_OggSyncState;
	ogg_page			m_OggPage;
	ogg_packet			m_OggPacket;
	ogg_stream_state	m_VideoStream;

	/* Theora stuff */
	theora_info			m_TheoraInfo;
	theora_comment		m_TheoraComment;
	theora_state		m_TheoraState;
	yuv_buffer			m_YUVFrame;
};

#endif // __THEORAPLAYER_H__
