#version 130
precision highp float;

// iOrange - uniforms
uniform sampler2D videoFrame;

// iOrange - incoming params
in vec2 tc;

// iOrange - outgoing params
out vec4 fragColor;

void main()
{
	vec4 outColor = vec4(1.0);

	vec3 yuv = texture(videoFrame, tc).xyz - vec3(0.0, 0.5, 0.5);

	yuv.x      = 1.1643 * (yuv.x - 0.0625);
	outColor.x = yuv.x + 1.5958  * yuv.z;
	outColor.y = yuv.x - 0.39173 * yuv.y - 0.81290 * yuv.z;
	outColor.z = yuv.x + 2.017   * yuv.y;

	fragColor = outColor;
}
