#ifndef __OPENGL_3_H__
#define __OPENGL_3_H__
#if _MSC_VER > 1000
#	pragma once
#endif	// #if _MSC_VER > 1000

class OpenGL_3
{
private:
	OpenGL_3() {}
	OpenGL_3(OpenGL_3&) {}
	virtual ~OpenGL_3() {}

public:

	static bool        Initialize( HWND hWnd, HGLRC& glRc, int color = 32, int depth = 24, bool forwardCompatible = true );
	static void        Shutdown( void );
	static void*       ProcedureAddress( const std::string& procName );
	static std::string GetVersion( void );
	static std::string GetVendor( void );
	static std::string GetRenderer( void );
	static std::string GetExtensions( void );
	static std::string GetWGLExtensions( void );
	static std::string GetGLSLVersion( void );
	static void        AssertGLError( void );
	static GLhandleARB CreateGLSLProgram( const std::string& vs, const std::string& fs );

private:

	static bool HaveOpenGL3Support( void );
	static bool CheckForGLSLErrors( GLhandleARB object );
};

#endif // __OPENGL_3_H__
