#pragma once

#ifndef _WIN32_WINNT			// Allow use of features specific to Windows XP or later
#	define _WIN32_WINNT 0x0501	// Change this to the appropriate value to target other versions of Windows.
#endif	// #ifndef _WIN32_WINNT

#include <stdio.h>
#include <tchar.h>

#include <windows.h>
#include <stddef.h>

#include <gl/gl.h>
#include "glext/glext.h"
#ifdef _MSC_VER
#	include "glext/wglext.h"
#else
#	include "glext/glxext.h"
#endif

#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <cassert>

typedef	__int64				int64;
typedef	unsigned __int64	uint64;
typedef	__int32				int32;
typedef	unsigned __int32	uint32;
typedef	__int16				int16;
typedef	unsigned __int16	uint16;
typedef	__int8				int8;
typedef	unsigned __int8		uint8;

static void Log_Normal( const std::string& msg )
{
	std::cout << "Log: " << msg << std::endl;
}
static void Log_Error( const std::string& msg )
{
	std::cout << "* ERROR *: " << msg << std::endl;
}
static void Log_Warning( const std::string& msg )
{
	std::cout << "! Warning: " << msg << std::endl;
}

#include "./MathLib/MathLib.h"
#include "./OGL_3/OpenGL_3.h"
#include "./OGLExtensions/OGLExtensions.h"

#define vbo_offsetof(s,m)	((GLvoid*)(offsetof(s,m)))
#define vbo_offset(off)		((GLvoid*)(off))
