//
// Copyright (C) iOrange 
// 
// File: pluginMain.cpp
//
// Author: Maya Plug-in Wizard 2.0
//

#include <stdlib.h>
#include <string.h>

#include <maya/MFStream.h>
#include <maya/MGlobal.h>
#include <maya/MString.h>

#include <maya/MFnPlugin.h>
#include <maya/MPxFileTranslator.h>

#include "MetroModelReader.h"


class MetroModelImport : public MPxFileTranslator
{
public:
	MetroModelImport();
	virtual ~MetroModelImport(); 

	MStatus				doIt(const MArgList &argList);
	static void*		creator();

	virtual MStatus		reader(const MFileObject& file, const MString& optionsString, FileAccessMode mode);

	virtual bool		haveReadMethod() const;
	virtual bool		haveWriteMethod() const;
	virtual bool		canBeOpened() const;
	virtual MString 	defaultExtension() const;
	virtual MFileKind	identifyFile(const MFileObject& fileName, const char* buffer, short size) const;
};


//
//	Description:
//		this method is called when the plug-in is loaded into Maya.  It 
//		registers all of the services that this plug-in provides with 
//		Maya.
//
//	Arguments:
//		obj - a handle to the plug-in object (use MFnPlugin to access it)
//
MStatus initializePlugin(MObject obj)
{ 
	MStatus   status;
	MFnPlugin plugin(obj, "iOrange", "8.5", "Any");

	// Add plug-in feature registration here
	//
	status = plugin.registerFileTranslator("MetroModelImport", "none", MetroModelImport::creator);
	return status;
}


//
//	Description:
//		this method is called when the plug-in is unloaded from Maya. It 
//		deregisters all of the services that it was providing.
//
//	Arguments:
//		obj - a handle to the plug-in object (use MFnPlugin to access it)
//
MStatus uninitializePlugin(MObject obj)
{
	MStatus   status;
	MFnPlugin plugin(obj);

	// Add plug-in feature deregistration here
	//
	status = plugin.deregisterFileTranslator("MetroModelImport");

	return status;
}




MetroModelImport::MetroModelImport() : MPxFileTranslator()
{
}
MetroModelImport::~MetroModelImport()
{
}


void* MetroModelImport::creator()
{
	return new MetroModelImport();
}

MStatus MetroModelImport::reader(const MFileObject& file, const MString& optionsString, FileAccessMode mode)
{
	MString fileName = file.fullName();

	CMetroModelReader modelReader;
	if (modelReader.OpenModelFile(fileName.asChar()))
		if (modelReader.ImportToMaya(MObject::kNullObj))
			return MS::kSuccess;

	DebugPrint(MString("reader failed"));
	return MS::kFailure;
}

bool MetroModelImport::haveReadMethod() const
{
	return true;
}
bool MetroModelImport::haveWriteMethod() const
{
	return false;
}
bool MetroModelImport::canBeOpened() const
{
	return false;
}
MString MetroModelImport::defaultExtension() const
{
	return MString("model");
}
MetroModelImport::MFileKind MetroModelImport::identifyFile(const MFileObject& fileName, const char* buffer, short size) const
{
	const char* name  = fileName.name().asChar();
	size_t nameLength = strlen(name);

	if ((nameLength > 6) && !strcasecmp(name+nameLength-6, ".model"))
		return kIsMyFileType;

	DebugPrint(fileName.name() + MString(" is not my file"));
	return kNotMyFileType;
}

